#!/usr/bin/perl -w 
#
# Script to parse the VNIC configuration file (/etc/infiniband/qlogic_vnic.cfg
# or /etc/sysconfig/ics_inic.cfg) and create VNIC interfaces by writing
# the required string to the /sys/class/infiniband_vnic/ files of the VNIC
# kernel driver
#
# Copyright (c) 2007 QLogic, Inc.  All rights reserved.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

use strict;

our $createfound = 0;
our (@lines, $primary_path, $secondary_path);
our ($line, $pstring , $sstring , $pname);
our ($path, $primary, $secondary, $create);
our ($instance, $port, $hca, $rx_csum, $heartbeat, $ioc_guid,
	$name, $tool_port1 ,$tool_port2, $discover_tool, $log);
our ($primary_file, $secondary_file, $hex, $prim_term, %parray,
	$sec_term, $c_term, $block_start);
our ($block_found, $ioc_string, $line_count, $err_flag,
	$prim_start, $sec_start, $create_start);
our ($verbose, $tempfile, $ioc_guid_found, $ioc_string_found,
	$prim, $sec, $file, $file2, $crt, $val_hca, $val_port, $val_ioc );
our ($prim_seen, $sec_seen,$prim_start_seen,$sec_start_seen, $found,$dgid_found_port, $warning_flag,
	$dev_umad0, $dev_umad1);

# prim_term =1 means term found, 0 means terminating brace not found.
# prim_seen = 1 means PRIMARY keyword followed by opening brace is seen
$prim_seen = 0;	
$sec_seen = 0;
$sec_start_seen = 0;
$prim_start_seen = 0;
$verbose = 0;
$crt = 0;
$ioc_string_found = 0;
$ioc_guid_found = 0;
$block_found = 0;		
%parray = ("name=", "", "ioc_guid=", 
	"", "dgid=", "", "pkey=", "", "instance=", "", "rx_csum=", "", "heartbeat=", "","ioc_string=","");
$pstring = "";
$sstring = "";
$primary = "PRIMARY";
$secondary = "SECONDARY";
$create = "CREATE";
$instance = "INSTANCE";
$port = "PORT";	
$hca ="HCA";
$rx_csum ="RX_CSUM";
$heartbeat ="HEARTBEAT";
$ioc_guid = "IOCGUID";
$ioc_string = "IOCSTRING";
$path = "/sys/class/infiniband_vnic/";
$name = "NAME";
$tempfile =`mktemp /tmp/qlvnic.XXXXXXXXXX`;
$tool_port1 = "ibvexdm -es -d /dev/infiniband/umad0";
$tool_port2 = "ibvexdm -es -d /dev/infiniband/umad1";
$dev_umad0 = "/dev/infiniband/umad0";
$dev_umad1 = "/dev/infiniband/umad1";
$discover_tool = "ibvexdm";
$hex = "0x";
$primary_file = "/create_primary";
$secondary_file = "/create_secondary";
$prim_term = 1;
$sec_term = 1;
$c_term = 1;
$err_flag = 0;
$line_count = 0;
$prim_start = 0;
$create_start = 0;
$sec_start = 0;
$block_start = 0;
$prim = 1;
$sec = 2;
$dgid_found_port = 0;
$val_hca = 0;
$val_port = 1;
$val_ioc = "";
$warning_flag = 0;
$file2 = "/etc/sysconfig/ics_inic.cfg";
$file = "/etc/infiniband/qlogic_vnic.cfg";
$log = "/var/log/messages";

sub print_err{
	my $temp;
	$temp = $0. ": ". $_[0];
	`logger $temp`;

}
	
# This function parses the line to find the parameters in array parray

sub get_params{
	my $line1;
	my $val_ioc_guid;
	my $rem;
	my $val_pkey;
	my $val_instance;
	my $val_name;
	my $val_dgid = 0;
	my ($path, $val_csum, $val_heartbeat, $val_ioc_string);
	my @parray1;
	my $string;
	$line1 = $_[0];

	if( $line1 =~ /$create/){
		print_err("Error: Keyword CREATE specified multiple times ");
		print_err("on line $line_count\n");
		exit_check();
	}
	if($_[2] == 1){
		if( $line1 =~ /$primary/){
			print_err( "Error: Keyword PRIMARY specified multiple times on line $line_count\n");
		exit_check();
		}
	}
	if($_[2] == 2){
		if( $line1 =~ /$secondary/){
			print_err("Error: Keyword SECONDARY specified multiple times on line $line_count\n");
			exit_check();
		}
	}
	if( $line1 =~ /$name/){
		print_err( "Error: NAME specified multiple times on line $line_count\n");
		exit_check();
	}		
			
	if( $line1 =~ /$ioc_string\s*=\s*/ ){
		$ioc_string_found = 1;
		if( !$ioc_guid_found ){
			($rem, $val_ioc_string) = split(/"/, $');
			$val_ioc = $val_ioc_string;
			$parray{"ioc_string="} = $val_ioc_string;
		}
		else{
			print_err( "Error: IOCSTRING as well as IOCGUID specified ");
			print_err( "on line $line_count\n");
			exit_check();
		}
	}
	if( $line1 =~ /$ioc_guid\s*=\s*/ ){
		$ioc_guid_found = 1;
		if( !$ioc_string_found ){
			if( $' =~ /\w*/ ){
				$val_ioc_guid = $&;
			}
			$parray{"ioc_guid="} = lc($val_ioc_guid);
		}
		else{
			print_err("Error: IOCSTRING as well as IOCGUID ");
			print_err("specified on $line_count\n");
			exit_check();
		}
	}
	if( $line1 =~ /$instance\s*=\s*/ ){
		if( $' =~ /\w*/ ){
			$val_instance = $&;
		}
		$parray{"instance="} = $val_instance;
	}
	if( $line1 =~ /$port\s*=\s*/ ){
		if( $' =~ /\w*/ ){
			$val_port = $&;
		}
	}
	if($line1 =~ /$hca\s*=\s*/){
		if( $' =~ /\w*/ ){
			$val_hca = $&;
		}
	}
	if( $line1 =~ /$rx_csum\s*=\s*/ ){
		if( $' =~ /\w*/ ){
			$val_csum = $&;
		}
		$parray{"rx_csum="} = lc($val_csum);
	}
	if( $line1 =~ /$heartbeat\s*=\s*/ ){
		if( $' =~ /\w*/ ){
			$val_heartbeat = $&;
		}
		$parray{"heartbeat="} = lc($val_heartbeat);
	}
	$parray{"name="} = $pname;
	if($line1 =~ /}/){
		$_[1] = 1;
		if ($ioc_guid_found){
			$val_ioc_guid = $parray{"ioc_guid="};
			if ($val_port eq "1"){
				$val_pkey = &parse_dgid(lc($val_ioc_guid), $val_dgid, $tool_port1, $dev_umad0);
			}
			else{
				$val_pkey = &parse_dgid(lc($val_ioc_guid), $val_dgid, $tool_port2,$dev_umad1);
			}
			if($val_dgid eq "0"){
				print_err( "Error: dgid not found with $discover_tool");
				print_err( "for interface $pname");
				print_err( "using port $val_port");
				exit_check();
			}
			$parray{"pkey="} = $val_pkey;
			$parray{"dgid="} = $val_dgid;
		}
		else {
			$val_ioc_string = $parray{"ioc_string="};
			if ($val_port eq "1"){
				$val_dgid = &parse_iocstring($val_ioc_string, $tool_port1, $dev_umad0);
			}
			else{
				$val_dgid = &parse_iocstring($val_ioc_string, $tool_port2, $dev_umad1);
			}
			if($val_dgid eq "0"){
				print_err( "Error: dgid not found with $discover_tool");
				print_err( "for interface $pname using port $val_port");
				exit_check();
			}
		}
		@parray1 = %parray;
		$string = &join_each(@parray1);			 
		chop($string);
		&write_to_file($string, $val_hca, $val_port, $_[2]);
		$prim_seen = 0;	
		$prim_start_seen = 0;
		$sec_start_seen = 0;
		$sec_seen = 0;
		if ($_[3] == 0){
			$c_term = 1;
			$createfound = 0;
			$block_found = 0;
			$pname="";
			$found = 0;
			if ($primary_path){
				system("echo \"$primary_path:$string\" >>$tempfile");
			}

		}
		#If terminating brace of create is on same line or terminating brace of create is found
		if ( ( $' =~ /}/ ) ){
			if ($_[2] == 1){
				if ($line1 =~ /$secondary/){
					return $string;	
				}
			}
						
			if ( $' =~ /}/) {
				print_err("Error: Extra terminating brace"); 
				print_err("on line $line_count\n");
				exit_check();
			}
			$c_term = 1;
			$createfound = 0;
			$block_found = 0;
			$found = 0;
			if ($_[2] == 1){
				$pstring = $string;
			}
			elsif ($_[2] == 2){
				$sstring = $string;
			}
		
			if ($primary_path){
				system("echo \"$primary_path:$pstring\" >>$tempfile");
			}
			if ($secondary_path){
				system("echo \"$secondary_path:$sstring\" >>$tempfile");
			}
		}
		return $string;	
	}
	else{
		$_[1] = 0;
	}

}	

# This function gets the dgid from the output of the tool , given iocguid 
sub parse_dgid {
	my @gline;
	my $line;
	my $dgid;
	my $rem;
	my $guid;
	my $pkey;
	my $err;
	my $tool;
	$err = -1;
	$tool = $_[2];

	if (-e $_[3]){
		print_err("Executing ibvexdm..........");
		@gline=`$tool`;
		if (!$#gline){
			print_err("Error in executing $discover_tool\n");
			$_[1] = 0;
			return;
		}
	}
	else{
		$_[1] = 0;
		return;
	}

	foreach $line( @gline ) {
		if($line =~ /ioc_guid=/) {
			($guid, $rem) = split( /,/, $' );
			if( $_[0] =~ /0x/ ){
				$guid = substr($guid, 3);	
				$guid = $hex.$guid;
			}
			if( $guid eq $_[0] ){
		     		if($line =~ /dgid=/) {
					($dgid, $rem) = split( /,/, $' );
					$line = $';
					$_[1] = $dgid;
					
					if($line =~ /pkey=/){
						($pkey, $rem) = split( /,/, $');
						return $pkey;
					}
				}
			}

		}
	}
	$_[1] = 0;

}

# This function gets the dgid with IOCSTRING as input
sub parse_iocstring {
	my @gline;
	my $line;
	my $dgid;
	my $rem;
	my $guid;
	my $pkey;
	my $iocstring;
	my $temp1;
	my ($temp2, $chk);
	my $input_string;
	my $tool;
	$input_string = $_[0];
	$tool = $_[1];
	if (-e $_[2]){
		print_err("Executing ibvexdm..........");
		@gline = `$tool`;
		if (!$#gline){
			print_err("Error in executing $discover_tool\n");
			return "0";
		}
	}
	else {
		return "0";
	}

	foreach $line(@gline) {
		if ($line =~ /".*"/){
			$iocstring = $&;
			($rem, $iocstring) = split( /"/, $iocstring );
			$chk = &chk_iostring($iocstring, $input_string);
			if ($chk == 1){
				($guid, $dgid, $pkey)=split( /,/, $line );
				if ($guid =~ "ioc_guid="){
					$guid = $';
				}
				if ($dgid =~ "dgid="){
					$dgid = $';
				}
				if ($pkey =~ "pkey="){
					$pkey = $';
				}
				$parray{"ioc_guid="} = $guid;
				if ($dgid){
					$parray{"dgid="} = $dgid;
					$parray{"pkey="} = $pkey;
					return $dgid;
				}
			}
		}
	}
	return "0";
}

# This function gets the matching iocstring from output of the tool
sub chk_iostring{
	my ($chassis1, $chassis2, $slot1, $slot2, $ioc1, $ioc2);
	my ($temp1, $temp2);
		$temp1 = $_[0];
		$temp2 = $_[1];
		($chassis1, $slot1, $ioc1) = split(/,/, $temp1);
		if ($chassis1 =~ /\s*Chassis\s*/){
			$chassis1 = $';
			$chassis1 = lc($chassis1);
		}	
		if ($slot1 =~ /\s*Slot\s*/){
			$slot1 = $';
		}	
		if ($ioc1 =~ /\s*IOC\s*/){
			$ioc1 = $';
		}

		($chassis2, $slot2, $ioc2) = split(/,/, $temp2);
		if ($chassis2 =~ /\s*Chassis\s*/){
			$chassis2 = $';
			$chassis2 = lc($chassis2);
		}	
		if ($slot2 =~ /\s*Slot\s*/){
			$slot2 = $';
		}	
		if ($ioc2 =~ /\s*IOC\s*/){
			$ioc2 = $';
		}
			
		if (($chassis1 eq $chassis2) && ($slot1 eq $slot2) && ($ioc1 eq $ioc2)){
			return 1;
		}
		else{
			return 0;
		}

}
	

sub write_to_file{
	my ($list, $filename, $hca, $port, %array);
	$list =`ls $path`;
	$hca = $_[1];
	$port = $_[2];
	$ioc_string_found = 0;
	$ioc_guid_found = 0;
	if ($list =~ /.*$hca-$port/ ) {
		$filename = $path.$&;
		if ($filename !~ /mthca/){
			print_err("Error! HCA is incompatible with VNIC driver - currently only MTHCA is supported");
			print_err("Aborting configuration of VNIC interfaces");
			exit_check();
		}
		if ( -d $filename){
			if( $_[3] == 1 ){
				$filename = $filename.$primary_file;
				$primary_path = $filename;
			}
			elsif ( $_[3] == 2 ){
				$filename = $filename.$secondary_file;
				$secondary_path = $filename;
			}
		}
		else{
			print_err("Error: Directory $filename not present");
			exit_check();
		}
	}
	else{
		print_err("Error: HCA $hca Port $port not present");
		exit_check();
	}
}

sub join_each{
	my @array = @_;
	my( $size, $string, $n, $val);
      	$n = 0;
	$val = 0;	
	$size = @array;
	while ($n < $size){
		$val = length($array[$n+1]);	
		if ($val){
			chomp($array[$n]);
			chomp($array[$n+1]);
			if (($array[$n] ne "ioc_string=")){
				$string = $string.$array[$n];
				$string = $string.$array[$n+1].",";
				chomp($string);
			}
		}
		else{
			if ($array[$n] eq "name="){
				print_err("Error: Missing NAME in block");
				print_err("on line $create_start\n");
				exit_check();
			}
			if ($array[$n] eq "ioc_guid="){
				print_err("Error: Missing IOCGUID in block ");
				print_err("on line $create_start\n");
				exit_check();
			}
		}
		$n = $n+2;
	}
	return $string;
}
	
sub init_array{
	$parray{"heartbeat="}="";
	$parray{"rx_csum="}="";
	$parray{"instance="}="";
	$parray{"name="}="";
	$parray{"pkey="}="";
	$parray{"ioc_guid="}="";
	$parray{"ioc_string="}="";
	$parray{"dgid="}="";
	$ioc_string_found = 0;
	$ioc_guid_found = 0;
	$val_port = 1;
	$val_hca = 0;
	$dgid_found_port = 0;
}

sub write_strings{
	my $file_handle;
	my @records;
	my $file_name;
	my $string;
	my $record;
					
	open(INFO,$tempfile );
	@records = <INFO>;
	close($tempfile);
	foreach $record (@records){
		($file_name, $string) = split(/:/, $record);
		chomp ($file_name);
		chomp ($string);
		if ($verbose){
			print_err("Writing $string to $file_name");
		}
		`echo -n $string > $file_name`;
		
		if ($?){
			print_err("Error: VNIC interface could not be created"); 
			exit_check();
		}
	}
}		

sub exit_check{
	chomp($tempfile);
	if (-e $tempfile){
		`rm -f $tempfile`;
	}
	exit(1);
}	

sub check_proper{
	my $line = $_[0];
	if ($line =~ /$secondary/){
		if (!($` =~ /{/)){
			print_err("Error: Missing opening brace before PRIMARY block on line $line_count\n");
			exit_check();
		}
	}
}
			
# Main routine 	
	my $ret;
	my $val_name;
	my $rem;
	$found=0;
	my $temp;

	if (!(-e $file)){
		if( !( -e $file2)){
			print_err("Error: Configuration file $file does not exist\n");
			print_err("Error: Configuration file $file2 does not exist\n");
			exit_check();
		}
		else{
			print_err("Configuration file $file does not exist\n");
			$file = $file2;
			print_err("Using configuration file $file2\n");
		}
	}	
	
	open(INFO, $file );
	@lines = <INFO>;
	close(INFO);
	`lsmod | grep \"ib_vnic\" `;
	if ($?){
		print_err("Error: VNIC module not loaded\n");
		exit_check();
	}	
	if ($#ARGV >= 0 ){	
		if ( $ARGV[0] eq "-v") {
			$verbose = 1;	
		}
	}
	foreach $line (@lines) {
		$line_count = $line_count + 1 ;
		chomp( $line );
		# If line is blank skip it
		if ($line =~ /^$/ ) {
		}	
		# If line is a comment skip it
		elsif ($line =~ /\s*#/){
			next;
		}
		# First opening brace found
		elsif (($line =~ /^\s*{/)){
			$line = $';	
			$block_found = 1;
			$block_start = $line_count;
			# Found CREATE block
			if (($line =~ /\s*$create/)){
				if ($' =~ /$create/){
					print_err("Error: CREATE keyword specified twice on line $line_count\n");
					exit_check();
				}
				if (!$sec_term){
					print_err("Error: Missing terminating brace in SECONDARY block");
					print_err("on line $sec_start\n");
					exit_check();
				}
				if (!$c_term){
					print_err("Error: Missing terminating brace in CREATE ");
					print_err("block on line $create_start");
					exit_check();
				}

				$create_start = $line_count;
				$createfound = 1;
				$found = 0;
				$c_term = 0;
				$pname = "";
				if( $line =~ /$name/){
					if ($' =~ /=/){
						($val_name,$rem) = split( /"/, $');
						$pname = $rem;
						$parray{"name="} = $pname;
					}
					else {
						print_err("Error: Syntax error in keyword NAME on line $line_count\n");
						exit_check();
					}
				}
				# Found PRIMARY within create  block
				if ($' =~ /\s*$primary/){
					$prim_start = $line_count;
					$temp = $';
					check_proper($');
					if ($temp =~ /{/){
						$prim_start_seen = 1;
						$pstring = get_params($', $prim_term, $prim, $prim);
						if ($prim_term == 1){
							init_array();
						}
					}
					else {
						$prim_start_seen = 0;
						$prim_term = 0;
					}
					$prim_seen = 1;
					$found=1;
				}
				# Found SECONDARY within create block
				if ($' =~ /\s*$secondary/){
					if (!$found){
						print_err("Error: Missing keyword PRIMARY on block on line $block_start\n");
						exit_check();
					}
					if(!$prim_term){
						print_err("Error: Missing terminating brace in PRIMARY block on line $line_count");
						exit_check();
					}
					$sec_start = $line_count;
					if ($' =~ /{/){
						$sec_start_seen = 1;
						$sstring = get_params($', $sec_term, $sec, $sec);
						if ($sec_term == 1){
							init_array();
						}
					}
					else {
						$sec_start_seen = 0;
						$sec_term = 0;
					}
					$sec_seen = 1;
					$found=1;
				}
				if (!$found){
					$pstring = get_params($',$c_term, $prim, $crt);
				}
			}
			else {
				if ((!$prim_term) && ($prim_seen)){
					$pstring = get_params($', $prim_term, $prim, $prim);
					if ($prim_term == 1){
						init_array();
					}
				}
				else {
					if ((!$c_term)){
						print_err("Missing terminating brace of CREATE block on line $create_start");
						exit_check();
					}
					if ($createfound){
						print_err("Error: Keyword PRIMARY/SECONDARY not specified on line $line_count\n");
						exit_check();
					}
				}

				if ((!$sec_term) && ($sec_seen)){
					$sstring = get_params($', $sec_term, $sec);
					if ($sec_term == 1){
						init_array();
					}
				}
				else {

					if ($createfound){
						print_err("Error: Keyword SECONDARY not specified on line $line_count\n");
						exit_check();
					}
				}
			}
		}
		elsif (($line =~ /$create/)){
			if (!$block_found) {
				print_err("Error: Missing opening brace before CREATE on line $line_count\n");
				exit_check();
			}
			if($createfound){
				print_err("Error: Missing terminating brace in CREATE block on line $create_start\n");
				exit_check();
			}
			$createfound = 1;
			$found =0;
			$create_start = $line_count;

		}
		# Found PRIMARY block
		elsif ( (($line =~ /\s*$primary/) || (!$prim_term)) && 
				( $createfound == 1 )){
			$found = 2;
		# If Primary block has not terminated
			if (!$prim_term){
				if (!$prim_start_seen){
					print_err("Error :Missing opening brace in PRIMARY block on line $line_count\n");
					exit_check();
				}	
				if ($line =~ /\s*$primary/){
					print_err("Error: Keyword PRIMARY");
					print_err(" specified multiple times on line $line_count\n");
					exit_check();
				}	
				$pstring = get_params($line, $prim_term, $prim, $prim);
				
			}
		# Start of primary block	
			else{
				$prim_term = 0;
				$prim_start = $line_count;
				if ($' =~ /\s*$primary/){
					print_err("Error: Keyword PRIMARY");
					print_err(" specified multiple times on line $line_count\n");
					exit_check();
				}
				if ($line =~ /\s*{\s*/ ){	
					$prim_start_seen = 1;
					$pstring = get_params($', $prim_term, $prim, $prim);
			
				}
			}
			if ($prim_term == 1){
				init_array();
			}
			if ((($line =~ /\s*$secondary/) || (!$sec_term))
			&& ($line !~ /\s*$create\s*/)){
				if (!$prim_term){
					print_err("Error: Missing terminating"); 
					print_err("brace in PRIMARY block"); 
					print_err("on line $prim_start\n");
					exit_check();
				}
				$found = 1;
				if (!$sec_term){
					if (!$sec_start_seen){
						print_err("Error :Missing opening brace ");
						print_err("in SECONDARY block on line $sec_start\n");
						exit_check();
					}	
					$sstring = get_params($line, $sec_term, $sec, $sec);
				}
				else{
					$sec_term = 0;
					$sec_start = $line_count;
					if($' =~ /\s*{\s*/ ){
						$sec_start_seen = 1;
						$sstring = get_params($', $sec_term, $sec, $sec);
					}
					if ($sec_term == 1){
					init_array();
                			}	
				}
			}

		}
		# If SECONDARY block found
		elsif ((($line =~ /\s*$secondary/) || (!$sec_term)) && ($line !~ /\s*$primary/) 
		&& ($line !~ /\s*$create\s*/)){
			if (!$found){
				print_err("Error: Missing keyword PRIMARY on block on $block_start\n");
				exit_check();
			} 
			if (!$prim_term){
				print_err("Error: Missing terminating brace ");
				print_err("in PRIMARY block on line $prim_start\n");
				exit_check();
			}
			$found = 2;
			# If SECONDARY block has not terminated
			if (!$sec_term){
				if (!$sec_start_seen){
					print_err("Error :Missing opening brace ");
					print_err("in SECONDARY block on line $sec_start\n");
					exit_check();
				}	
				$sstring = get_params($line, $sec_term, $sec, $sec);
			}
			# Start of SECONDARY block
			else{
				$sec_term = 0;
				$sec_start = $line_count;
				if($line =~ /\s*{\s*/ ){
					$sec_start_seen = 1;
					$sstring = get_params($', $sec_term, $sec, $sec);
				}
			}
			if ($sec_term == 1){
				
				init_array();
                	}
		}
		# If the CREATE block doesnt contain PRIMARY or SECONDARY blocks
		elsif (( $createfound == 1) && (!$found)){
			if( $line =~ /$name/){
				if ($' =~ /=/){
					($val_name,$rem) = split( /"/, $');
					$pname = $rem;
					$parray{"name="} = $pname;
					$pstring = get_params( $', $c_term, $prim, $crt);
				}
				else {
					print_err("Error: Syntax error in keyword NAME on line $line_count\n");
					exit_check();
				}
			}
			else{
				$pstring = get_params( $line, $c_term, $prim, $crt);
			}
		}
		# Closing brace found
		elsif (($line =~ /}/) ){
			if ((!$createfound)){
				if ($block_start){
					print_err("Error: Missing keyword CREATE ");
					print_err("on line $block_start\n");
				}
				else {
					print_err("Error: Missing keyword CREATE \n");
				}
				exit_check();
			}
			if (!$block_found){
				print_err("Error: Extra closing brace on line $line_count\n");
				exit_check();
			}
			$prim_seen = 0;		
			$sec_seen = 0;
			$prim_start_seen =0;
			$sec_start_seen = 0;
			$c_term = 1;
			$createfound = 0;
			$block_found = 0;
			if ($primary_path){
				$ret = system("echo \"$primary_path:$pstring\" >>$tempfile");
			}
			if ($secondary_path){
				$ret = system("echo \"$secondary_path:$sstring\" >>$tempfile");
			}
			$found = 0;
			$primary_path = "";
			$secondary_path = "";
			init_array();

		}

	}	
	if (!$prim_term){
		print_err("Error: Missing terminating brace in PRIMARY block");
		print_err("on line $prim_start \n");
		exit_check();
	}
	if (!$sec_term){
		print_err("Error: Missing terminating brace in SECONDARY block ");
		print_err("on line $sec_start\n");
		exit_check();
	}
	if (!$c_term){
		print_err("Error: Missing terminating brace in CREATE block ");
		print_err("on line $create_start\n");
		exit_check();
	}
	&write_strings();
	`rm -f $tempfile`;
	if ($warning_flag){
		exit(2);
	}
